# Rosie Website Texting Widget - WordPress Plugin

Turn your website visitors into valuable leads with AI-powered text conversations.

## Installation

### Option 1: Upload via WordPress Admin
1. Download the `rosie-website-texting-widget.zip` file from the link provided in the installation guide
2. Go to your WordPress admin → **Plugins** → **Add New** → **Upload Plugin**
3. Upload the `rosie-website-texting-widget.zip` file
4. Click **Install Now**, then **Activate**

### Option 2: Manual Upload
1. Upload the `rosie-website-texting-widget` folder to `/wp-content/plugins/` on your server
2. Go to WordPress admin → **Plugins**
3. Find "Rosie Website Texting Widget" and click **Activate**

## Configuration

1. Go to **Settings** → **Rosie** in your WordPress admin
2. Enter your **Business ID**
3. Click **Save Changes**

The widget will now appear on all pages of your website.

## Where to Find Your Business ID

1. Log in to your [Rosie Admin](https://heyrosie.com/admin)
2. Go to **Settings** → **Website Texting**
3. Scroll to the **Installation** section
4. Find your Business ID in the **Installation Code** card

The Business ID is the value shown in the `data-rosie-business-id` attribute of the installation code snippet.

## Customizing the Widget

To customize your widget's appearance (colors, avatar, greeting message, position):

1. Go to your [Rosie Admin](https://heyrosie.com/admin/settings;section=website-texting)
2. Navigate to **Settings** → **Website Texting**
3. Click **Edit** in the **Widget Customization** section
4. Make your changes and save

Changes will apply automatically to your WordPress site.

## Removing the Widget

To remove the widget from your website:

1. Go to WordPress admin → **Plugins**
2. Find "Rosie Website Texting Widget"
3. Click **Deactivate** (widget stops appearing immediately)
4. Optionally click **Delete** to fully uninstall

## Displaying on Specific Pages Only

By default, the widget appears on all pages. To control which pages display the widget, add one of the following code snippets to your theme's `functions.php` file (or use a code snippets plugin).

### Show only on specific pages

```php
// Only show the Rosie widget on specific pages
add_action( 'template_redirect', function() {
    if ( ! is_page( array( 'contact', 'pricing', 'get-a-quote' ) ) ) {
        remove_action( 'wp_footer', 'rosie_widget_inject_script' );
    }
});
```

Replace `'contact', 'pricing', 'get-a-quote'` with the slugs of the pages where you want the widget to appear.

### Hide on specific pages

```php
// Hide the Rosie widget on specific pages
add_action( 'template_redirect', function() {
    if ( is_page( array( 'careers', 'privacy-policy' ) ) ) {
        remove_action( 'wp_footer', 'rosie_widget_inject_script' );
    }
});
```

Replace `'careers', 'privacy-policy'` with the slugs of the pages where you want to hide the widget.

### Show only on the homepage

```php
// Only show the Rosie widget on the homepage
add_action( 'template_redirect', function() {
    if ( ! is_front_page() ) {
        remove_action( 'wp_footer', 'rosie_widget_inject_script' );
    }
});
```

## Troubleshooting

| Issue | Solution |
|-------|----------|
| Widget not appearing | Verify your Business ID is correct and saved |
| Widget on wrong pages | See the [Displaying on Specific Pages Only](#displaying-on-specific-pages-only) section above |
| Styling conflicts | Check for CSS conflicts with your theme |

## Support

- Email: support@heyrosie.com
- Help Center: [heyrosie.com/support](https://heyrosie.com/support)
